// generated by diplomat-tool
import { DataError } from "./DataError.mjs"
import { DataProvider } from "./DataProvider.mjs"
import { GeneralCategoryGroup } from "./GeneralCategoryGroup.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * A type capable of looking up General Category Group values from a string name.
 *
 * See the [Rust documentation for `PropertyParser`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParser.html) for more information.
 *
 * See the [Rust documentation for `GeneralCategory`](https://docs.rs/icu/latest/icu/properties/props/enum.GeneralCategory.html) for more information.
 */
const GeneralCategoryNameToGroupMapper_box_destroy_registry = new FinalizationRegistry((ptr) => {
    wasm.icu4x_GeneralCategoryNameToGroupMapper_destroy_mv1(ptr);
});

export class GeneralCategoryNameToGroupMapper {
    // Internal ptr reference:
    #ptr = null;

    // Lifetimes are only to keep dependencies alive.
    // Since JS won't garbage collect until there are no incoming edges.
    #selfEdge = [];

    #internalConstructor(symbol, ptr, selfEdge) {
        if (symbol !== diplomatRuntime.internalConstructor) {
            console.error("GeneralCategoryNameToGroupMapper is an Opaque type. You cannot call its constructor.");
            return;
        }
        this.#ptr = ptr;
        this.#selfEdge = selfEdge;

        // Are we being borrowed? If not, we can register.
        if (this.#selfEdge.length === 0) {
            GeneralCategoryNameToGroupMapper_box_destroy_registry.register(this, this.#ptr);
        }

        return this;
    }
    get ffiValue() {
        return this.#ptr;
    }


    /**
     * Get the mask value matching the given name, using strict matching
     *
     * Returns 0 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_strict`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_strict) for more information.
     */
    getStrict(name) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const nameSlice = diplomatRuntime.DiplomatBuf.str8(wasm, name);

        const result = wasm.icu4x_GeneralCategoryNameToGroupMapper_get_strict_mv1(this.ffiValue, ...nameSlice.splat());

        try {
            return GeneralCategoryGroup._fromFFI(diplomatRuntime.internalConstructor, result);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Get the mask value matching the given name, using loose matching
     *
     * Returns 0 if the name is unknown for this property
     *
     * See the [Rust documentation for `get_loose`](https://docs.rs/icu/latest/icu/properties/struct.PropertyParserBorrowed.html#method.get_loose) for more information.
     */
    getLoose(name) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const nameSlice = diplomatRuntime.DiplomatBuf.str8(wasm, name);

        const result = wasm.icu4x_GeneralCategoryNameToGroupMapper_get_loose_mv1(this.ffiValue, ...nameSlice.splat());

        try {
            return GeneralCategoryGroup._fromFFI(diplomatRuntime.internalConstructor, result);
        }

        finally {
            functionCleanupArena.free();

        }
    }

    /**
     * Create a name-to-mask mapper for the `General_Category` property, using compiled data.
     *
     * See the [Rust documentation for `GeneralCategoryGroup`](https://docs.rs/icu/latest/icu/properties/props/struct.GeneralCategoryGroup.html) for more information.
     */
    #defaultConstructor() {

        const result = wasm.icu4x_GeneralCategoryNameToGroupMapper_create_mv1();

        try {
            return new GeneralCategoryNameToGroupMapper(diplomatRuntime.internalConstructor, result, []);
        }

        finally {
        }
    }

    /**
     * Create a name-to-mask mapper for the `General_Category` property, using a particular data source.
     *
     * See the [Rust documentation for `GeneralCategoryGroup`](https://docs.rs/icu/latest/icu/properties/props/struct.GeneralCategoryGroup.html) for more information.
     */
    static createWithProvider(provider) {
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_GeneralCategoryNameToGroupMapper_create_with_provider_mv1(diplomatReceive.buffer, provider.ffiValue);

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new DataError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('DataError: ' + cause.value, { cause });
            }
            return new GeneralCategoryNameToGroupMapper(diplomatRuntime.internalConstructor, diplomatRuntime.ptrRead(wasm, diplomatReceive.buffer), []);
        }

        finally {
            diplomatReceive.free();
        }
    }

    constructor() {
        if (arguments[0] === diplomatRuntime.exposeConstructor) {
            return this.#internalConstructor(...Array.prototype.slice.call(arguments, 1));
        } else if (arguments[0] === diplomatRuntime.internalConstructor) {
            return this.#internalConstructor(...arguments);
        } else {
            return this.#defaultConstructor(...arguments);
        }
    }
}