// generated by diplomat-tool
import type { Locale } from "./Locale"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * The various calendar types currently supported by [`Calendar`]
 *
 * See the [Rust documentation for `AnyCalendarKind`](https://docs.rs/icu/latest/icu/calendar/enum.AnyCalendarKind.html) for more information.
 */


export class CalendarKind {

    static fromValue(value: CalendarKind | string): CalendarKind;

    get value(): string;

    get ffiValue(): number;

    static Iso : CalendarKind;
    static Gregorian : CalendarKind;
    static Buddhist : CalendarKind;
    static Japanese : CalendarKind;
    static JapaneseExtended : CalendarKind;
    static Ethiopian : CalendarKind;
    static EthiopianAmeteAlem : CalendarKind;
    static Indian : CalendarKind;
    static Coptic : CalendarKind;
    static Dangi : CalendarKind;
    static Chinese : CalendarKind;
    static Hebrew : CalendarKind;
    static HijriTabularTypeIiFriday : CalendarKind;
    static HijriSimulatedMecca : CalendarKind;
    static HijriTabularTypeIiThursday : CalendarKind;
    static HijriUmmAlQura : CalendarKind;
    static Persian : CalendarKind;
    static Roc : CalendarKind;


    /**
     * Creates a new [`CalendarKind`] for the specified locale, using compiled data.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/calendar/enum.AnyCalendarKind.html#method.new) for more information.
     */
    static create(locale: Locale): CalendarKind;

    constructor(value: CalendarKind | string );
}