#! /bin/sh
##
## Copyright (C) by Argonne National Laboratory
##     See COPYRIGHT in top-level directory
##

echo_n() {
    # "echo -n" isn't portable, must portably implement with printf
    printf "%s" "$*"
}

check_python3() {
    echo_n "Checking for Python 3... "
    PYTHON=

    python_one_liner="import sys; print(sys.version_info[0])"
    PYTHON_PATH=`command -v python`
    if test "x$PYTHON_PATH" != x ; then
        version=`$PYTHON_PATH -c "$python_one_liner"`
        if test "$version" = 3 ; then
            PYTHON=$PYTHON_PATH
        fi
    fi
    if test "x$PYTHON" = x ; then
        PYTHON_PATH=`command -v python3`
        if test "x$PYTHON_PATH" != x ; then
            version=`$PYTHON_PATH -c "$python_one_liner"`
            if test "$version" = 3 ; then
                PYTHON=$PYTHON_PATH
            fi
        fi
    fi

    if test -z "$PYTHON" ; then
        echo "not found"
        exit 1
    else
        echo "$PYTHON"
    fi
}

if test -z "$PYTHON" ; then
    check_python3
fi
echo "Generating collective cvar tests"
$PYTHON maint/gen_coll_cvar.py

check_copy() {
    name=$1
    orig=$2
    printf "Checking $name... "
    if test ! -e $name ; then
        if test -e $orig; then
            cp -a $orig $name
            echo "copy from $orig"
        else
            echo "missing"
            exit 1
        fi
    else
        echo "found"
    fi
}

generate_benchmarks() {
    MYDEF_BOOT=$PWD/../../modules/mydef_boot
    if test -d $MYDEF_BOOT ; then
        echo "Generating benchmark tests"
        export PATH=$MYDEF_BOOT/bin:$PATH
        export PERL5LIB=$MYDEF_BOOT/lib/perl5
        export MYDEFLIB=$MYDEF_BOOT/lib/MyDef
        (cd bench && ./autogen.sh)
    fi
}

check_copy version.m4     ../../maint/version.m4
check_copy confdb         ../../confdb
check_copy dtpools/confdb ../../confdb

# mtest_mpix.h is generated by mpich autogen, specifically, gen_binding_c.py.
# It provides macros that replace upcoming MPI functions with MPIX prefix.
# The tests using these new functions should not be included with
# --enable-strictmpi, an option should be given when testing general MPI
# implementations.
#
# Here we supply an empty stub when this is run outside mpich.
#
if test ! -e include/mtest_mpix.h ; then
    touch include/mtest_mpix.h
fi

# Generate the benchmark tests
generate_benchmarks

echo "Running autoreconf in dtpools"
(cd dtpools && autoreconf -ivf)

# Create and/or update the f90 tests
printf "Create or update the Fortran 90 tests derived from the Fortran 77 tests... "
for dir in f77/* ; do
    if [ ! -d $dir ] ; then continue ; fi
    leafDir=`basename $dir`
    if [ ! -d f90/$leafDir ] ; then
	mkdir f90/$leafDir
    fi
    if maint/f77tof90 $dir f90/$leafDir Makefile.am Makefile.ap ; then
        echo "timestamp" > f90/$leafDir/Makefile.am-stamp
    else
        echo "failed"
        error "maint/f77tof90 $dir failed!"
        exit 1
    fi
done
for dir in errors/f77/* ; do
    if [ ! -d $dir ] ; then continue ; fi
    leafDir=`basename $dir`
    if [ ! -d errors/f90/$leafDir ] ; then
	mkdir errors/f90/$leafDir
    fi
    if maint/f77tof90 $dir errors/f90/$leafDir Makefile.am Makefile.ap ; then
        echo "timestamp" > errors/f90/$leafDir/Makefile.am-stamp
    else
        echo "failed"
        error "maint/f77tof90 $dir failed!"
        exit 1
    fi
done
echo "done"

echo "Running autoreconf in ."
autoreconf -ivf
