# 2021-08-17 Triage Log

A fairly busy week which was to expected given that we've [adjusted our algorithm](https://github.com/rust-lang/rustc-perf/pull/956) for whether we label a change as a regression or not. Most regressions were relatively small, and only one has not yet been addressed in some way.

Triage done by **@rylev**.
Revision range: [6b20506d17f4e5e5bf5bcad7e94add4d754b0ae3..aa8f27bf4d980023a8b245ceb25a490a18041eb2](https://perf.rust-lang.org/?start=6b20506d17f4e5e5bf5bcad7e94add4d754b0ae3&end=aa8f27bf4d980023a8b245ceb25a490a18041eb2&absolute=false&stat=instructions%3Au)
59 comparisons made in total

3 Regressions, 2 Improvements, 2 Mixed; 0 of them in rollups

#### Regressions

encode `generics_of` for fields and ty params [#87815](https://github.com/rust-lang/rust/issues/87815)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2d10c2a3302d53e10a4ad3ac581103faaae9eeb6&end=c4c2986c499ee9440b7ae23bf5a62c6168e1ce17&stat=instructions:u) (up to 1.2% on `incr-unchanged` builds of `diesel`)
- While the regressions are fairly small, the largest ones seem to be happening in real-world crates like diesel, serde, and futures. 
- The largest regressions seem to be in the `explicit_predicates_of` query which would seem to be directly impacted by this change.
- Left a [comment](https://github.com/rust-lang/rust/pull/87815#issuecomment-900465263) to see how we should address this issue. 


Various refactorings of the TAIT infrastructure [#87587](https://github.com/rust-lang/rust/issues/87587)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=47b41b7788a6f85c749049062f1e4eed497cd894&end=d488de82f30fd1dcb0220d57498638596622394e&stat=instructions:u) (up to 1.5% on `full` builds of `inflate`)
- The issue is [expected](https://github.com/rust-lang/rust/pull/87587#issuecomment-896754235) and is being monitored with a possible solution in the works.


Name the captured upvars for closures/generators in debuginfo [#85020](https://github.com/rust-lang/rust/issues/85020)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c6094fc7b9981d755abeb8c0e866a0f6315b3ec3&end=99efc51dae1dbe9d741707a7ddef84c29e654df5&stat=instructions:u) (up to 4.9% on `incr-patched: println` builds of `webrender-wrench`)
- This is a large regression in one benchmark, but it seems to be in codegen which this change would impact. 
- [There is a comment](https://github.com/rust-lang/rust/pull/85020#issuecomment-898823772) justifying this as concerning but worth it given it only impacts one benchmark. I still believe this might be one worth keeping an eye on.


#### Improvements

Avoid using the `copy_nonoverlapping` wrapper through `mem::replace`. [#87827](https://github.com/rust-lang/rust/issues/87827)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e8c25f266349a68faa8c4fb68f5c1d5e4512790f&end=4e886d68766719a7fc1714c52a0e7e81929e8b8e&stat=instructions:u) (up to -2.2% on `incr-patched: u8 3072` builds of `issue-46449`)


Run RemoveZsts pass at mir-opt-level=1 [#83417](https://github.com/rust-lang/rust/issues/83417)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e55c13e1099b78b1a485202fabc9c1b10b1f1d15&end=8007b506ac5da629f223b755f5a5391edd5f6d01&stat=instructions:u) (up to -4.3% on `incr-unchanged` builds of `deeply-nested-async`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e55c13e1099b78b1a485202fabc9c1b10b1f1d15&end=8007b506ac5da629f223b755f5a5391edd5f6d01&stat=instructions:u) (up to 0.8% on `full` builds of `tokio-webpush-simple`)
- Although this meets the criteria for being a mixed run, the improvements far outweigh the regressions so we'll label it as an improvement.

#### Mixed


Introduce `hir::ExprKind::Let` - Take 2 [#80357](https://github.com/rust-lang/rust/issues/80357)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2bd17c1d43bba43412cc2f051323a279d6751e43&end=2a6fb9a4c0e5ca7a81999065943b211c226fe9d8&stat=instructions:u) (up to -2.1% on `incr-patched: println` builds of `webrender`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2bd17c1d43bba43412cc2f051323a279d6751e43&end=2a6fb9a4c0e5ca7a81999065943b211c226fe9d8&stat=instructions:u) (up to 0.7% on `full` builds of `cranelift-codegen`)


BTree: merge the complication introduced by #81486 and #86031 [#87696](https://github.com/rust-lang/rust/issues/87696)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2a6fb9a4c0e5ca7a81999065943b211c226fe9d8&end=23461b210f1b0a121592a18fc4fb666106006668&stat=instructions:u) (up to -0.6% on `full` builds of `issue-46449`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2a6fb9a4c0e5ca7a81999065943b211c226fe9d8&end=23461b210f1b0a121592a18fc4fb666106006668&stat=instructions:u) (up to 1.7% on `full` builds of `ripgrep`)
- This is mostly a wash in terms of performance (with performance shifting somewhat equally across all the benchmarks), with the largest changes happening in stress tests.


#### Untriaged Pull Requests

- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)

