# 2025-02-18 Triage Log

This week's results were dominated by the update to LLVM 20 ([#135763](https://github.com/rust-lang/rust/pull/135763)),
which brought a large number of performance improvements, as usual. There were also two other
significant improvements, caused by improving the representation of `const` values ([#136593](https://github.com/rust-lang/rust/pull/136593)) and doing less work when formatting in `rustdoc` ([#136828](https://github.com/rust-lang/rust/pull/136828)).

Triage done by **@kobzol**.
Revision range: [c03c38d5..ce36a966](https://perf.rust-lang.org/?start=c03c38d5c2368cd2aa0e056dba060b94fc747f4e&end=ce36a966c79e109dabeef7a47fe68e5294c6d71e&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 4.4%  | [0.2%, 35.8%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.2%, 5.0%]    | 13    |
| Improvements ✅ <br /> (primary)   | -1.6% | [-10.5%, -0.2%] | 256   |
| Improvements ✅ <br /> (secondary) | -1.0% | [-4.7%, -0.2%]  | 163   |
| All ❌✅ (primary)                 | -1.3% | [-10.5%, 35.8%] | 266   |


3 Regressions, 2 Improvements, 4 Mixed; 4 of them in rollups
50 artifact comparisons made in total

#### Regressions

Rollup of 8 pull requests [#136918](https://github.com/rust-lang/rust/pull/136918) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=021fb9c09a19d206a37226fe6168f1cc7c984925&end=552a959051cebf8f88a8f558399baf733bec9ce0&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9% | [0.1%, 2.1%] | 19    |
| Regressions ❌ <br /> (secondary)  | 1.7% | [0.3%, 4.9%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.9% | [0.1%, 2.1%] | 19    |

- Regression on a number of `doc` benchmarkes caused by [#136829](https://github.com/rust-lang/rust/pull/136829).
- Continuing discussion on that PR, not marking as triaged yet.

Rollup of 10 pull requests [#136943](https://github.com/rust-lang/rust/pull/136943) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ced8e650cddbafad92094b2c89dee97b8a807d9c&end=ef148cd7eb00a5a973130dc6473da71fd6c487ee&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.4%, 0.7%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 1     |

- Small regression on a bunch of secondary benchmarks caused by [#136901](https://github.com/rust-lang/rust/pull/136901).
- Does not seem worthy of further work.
- Marked as triaged.

Rollup of 11 pull requests [#137001](https://github.com/rust-lang/rust/pull/137001) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a567209daab72b7ea59eac533278064396bb0534&end=6dfeab5c9e8a17a6636c1479037baabc4b1e9562&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.8%, 0.9%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.1% | [0.1%, 0.1%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.8%, 0.9%] | 2     |

- A few small regressions were caused by [#136928](https://github.com/rust-lang/rust/pull/136928).
- That PR was a fix and the regressions were small, so no further work is needed.
- Marked as triaged.

#### Improvements

valtree performance tuning [#136593](https://github.com/rust-lang/rust/pull/136593) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=54cdc751df770517e70db0588573e32e6a7b9821&end=c241e146506600f5ab7f4026ff015df8a658400e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -2.6% | [-5.6%, -0.2%] | 20    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -2.6% | [-5.6%, -0.2%] | 20    |

- Resolves a previous perf. regression from https://github.com/rust-lang/rust/pull/136180, and then some.

Do more lazy-formatting in librustdoc [#136828](https://github.com/rust-lang/rust/pull/136828) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c07d140e00dfa5b0988754051d07d8a91ff01f7&end=69fd5e4059f8840f09f60269bcda23dcdcb77151&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -1.6% | [-10.3%, -0.3%] | 17    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.2%]  | 3     |
| All ❌✅ (primary)                 | -1.6% | [-10.3%, -0.3%] | 17    |

- A great win for doc benchmarks.

#### Mixed

Portable SIMD subtree update [#135701](https://github.com/rust-lang/rust/pull/135701) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8c04e395952022a451138dc4dbead6dd6ae65203&end=4b293d99275cc63b07eec9e2de38f4b776989069&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.6%]   | 17    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [0.5%, 0.5%]   | 1     |

- Tiny regressions in doc builds, probably caused by more documentation in portable-simd.
- Marked as triaged.

transmute should also assume non-null pointers [#136735](https://github.com/rust-lang/rust/pull/136735) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=905b1bf1ccccaf091a880b069f80dc38ad9ecad3&end=d88ffcdb8bfc6f8b917574c1693eb9764a20eff5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.8%]   | 4     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.0%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-1.0%, 0.8%]  | 11    |

- Performance is a wash.
- Marked as triaged.

Rollup of 7 pull requests [#137163](https://github.com/rust-lang/rust/pull/137163) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d5eb31c9347ae3c494c8d723711dacca7d1cfe8b&end=273465e1f2932a30a5b56ac95859cdc86f3f33fa&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.3%] | 2     |

- Three tiny changes, the only regression is on an incr-unchanged run of a parser stress test,
  probably doesn't warrant further investigation.
- Marked as triaged.

Update to LLVM 20 [#135763](https://github.com/rust-lang/rust/pull/135763) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2162e9d4b18525e4eb542fed9985921276512d7c&end=ce36a966c79e109dabeef7a47fe68e5294c6d71e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 5.1%  | [0.2%, 35.1%]  | 8     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 1.0%]   | 10    |
| Improvements ✅ <br /> (primary)   | -1.3% | [-4.2%, -0.2%] | 251   |
| Improvements ✅ <br /> (secondary) | -1.0% | [-4.7%, -0.1%] | 178   |
| All ❌✅ (primary)                 | -1.1% | [-4.2%, 35.1%] | 259   |

- As usual, update to a new lLVM version brings a lot of performance wins, but also some regressions.
- The single large regression was on a release (optimized) incremental build, which is not a
configuration used much in practice. It was caused by a codegen unit becoming unnecessarily large. 
- Marked as triaged.
