//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armrecoveryservices.ClientFactory type.
type ServerFactory struct {
	Server                     Server
	OperationsServer           OperationsServer
	PrivateLinkResourcesServer PrivateLinkResourcesServer
	RegisteredIdentitiesServer RegisteredIdentitiesServer
	ReplicationUsagesServer    ReplicationUsagesServer
	UsagesServer               UsagesServer
	VaultCertificatesServer    VaultCertificatesServer
	VaultExtendedInfoServer    VaultExtendedInfoServer
	VaultsServer               VaultsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armrecoveryservices.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armrecoveryservices.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                          *ServerFactory
	trMu                         sync.Mutex
	trServer                     *ServerTransport
	trOperationsServer           *OperationsServerTransport
	trPrivateLinkResourcesServer *PrivateLinkResourcesServerTransport
	trRegisteredIdentitiesServer *RegisteredIdentitiesServerTransport
	trReplicationUsagesServer    *ReplicationUsagesServerTransport
	trUsagesServer               *UsagesServerTransport
	trVaultCertificatesServer    *VaultCertificatesServerTransport
	trVaultExtendedInfoServer    *VaultExtendedInfoServerTransport
	trVaultsServer               *VaultsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "RegisteredIdentitiesClient":
		initServer(s, &s.trRegisteredIdentitiesServer, func() *RegisteredIdentitiesServerTransport {
			return NewRegisteredIdentitiesServerTransport(&s.srv.RegisteredIdentitiesServer)
		})
		resp, err = s.trRegisteredIdentitiesServer.Do(req)
	case "ReplicationUsagesClient":
		initServer(s, &s.trReplicationUsagesServer, func() *ReplicationUsagesServerTransport {
			return NewReplicationUsagesServerTransport(&s.srv.ReplicationUsagesServer)
		})
		resp, err = s.trReplicationUsagesServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "VaultCertificatesClient":
		initServer(s, &s.trVaultCertificatesServer, func() *VaultCertificatesServerTransport {
			return NewVaultCertificatesServerTransport(&s.srv.VaultCertificatesServer)
		})
		resp, err = s.trVaultCertificatesServer.Do(req)
	case "VaultExtendedInfoClient":
		initServer(s, &s.trVaultExtendedInfoServer, func() *VaultExtendedInfoServerTransport {
			return NewVaultExtendedInfoServerTransport(&s.srv.VaultExtendedInfoServer)
		})
		resp, err = s.trVaultExtendedInfoServer.Do(req)
	case "VaultsClient":
		initServer(s, &s.trVaultsServer, func() *VaultsServerTransport { return NewVaultsServerTransport(&s.srv.VaultsServer) })
		resp, err = s.trVaultsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
