//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armloadtesting_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/loadtesting/armloadtesting"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_ListBySubscription.json
func ExampleLoadTestsClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLoadTestsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LoadTestResourcePageList = armloadtesting.LoadTestResourcePageList{
		// 	Value: []*armloadtesting.LoadTestResource{
		// 		{
		// 			Name: to.Ptr("myLoadTest"),
		// 			Type: to.Ptr("Microsoft.LoadTestService/loadTests"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.LoadTestService/loadTests/myLoadTest"),
		// 			SystemData: &armloadtesting.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("userId1001"),
		// 				CreatedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("userId1001"),
		// 				LastModifiedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"Team": to.Ptr("Dev Exp"),
		// 			},
		// 			Properties: &armloadtesting.LoadTestProperties{
		// 				Description: to.Ptr("This is new load test resource"),
		// 				DataPlaneURI: to.Ptr("https://myLoadTest.00000000-0000-0000-0000-000000000000.cnt-dp.domain.com"),
		// 				ProvisioningState: to.Ptr(armloadtesting.ResourceStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_ListByResourceGroup.json
func ExampleLoadTestsClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLoadTestsClient().NewListByResourceGroupPager("dummyrg", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.LoadTestResourcePageList = armloadtesting.LoadTestResourcePageList{
		// 	Value: []*armloadtesting.LoadTestResource{
		// 		{
		// 			Name: to.Ptr("myLoadTest"),
		// 			Type: to.Ptr("Microsoft.LoadTestService/loadTests"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.LoadTestService/loadTests/myLoadTest"),
		// 			SystemData: &armloadtesting.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
		// 				CreatedBy: to.Ptr("userId1001"),
		// 				CreatedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("userId1001"),
		// 				LastModifiedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westus"),
		// 			Tags: map[string]*string{
		// 				"Team": to.Ptr("Dev Exp"),
		// 			},
		// 			Properties: &armloadtesting.LoadTestProperties{
		// 				Description: to.Ptr("This is new load test resource"),
		// 				DataPlaneURI: to.Ptr("https://myLoadTest.00000000-0000-0000-0000-000000000000.cnt-dp.domain.com"),
		// 				ProvisioningState: to.Ptr(armloadtesting.ResourceStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_Get.json
func ExampleLoadTestsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewLoadTestsClient().Get(ctx, "dummyrg", "myLoadTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoadTestResource = armloadtesting.LoadTestResource{
	// 	Name: to.Ptr("myLoadTest"),
	// 	Type: to.Ptr("Microsoft.LoadTestService/loadTests"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.LoadTestService/loadTests/myLoadTest"),
	// 	SystemData: &armloadtesting.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("userId1001"),
	// 		CreatedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("userId1001"),
	// 		LastModifiedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"Team": to.Ptr("Dev Exp"),
	// 	},
	// 	Properties: &armloadtesting.LoadTestProperties{
	// 		Description: to.Ptr("This is new load test resource"),
	// 		DataPlaneURI: to.Ptr("https://myLoadTest.00000000-0000-0000-0000-000000000000.cnt-dp.domain.com"),
	// 		ProvisioningState: to.Ptr(armloadtesting.ResourceStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_CreateOrUpdate.json
func ExampleLoadTestsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLoadTestsClient().BeginCreateOrUpdate(ctx, "dummyrg", "myLoadTest", armloadtesting.LoadTestResource{
		Location: to.Ptr("westus"),
		Tags: map[string]*string{
			"Team": to.Ptr("Dev Exp"),
		},
		Identity: &armloadtesting.ManagedServiceIdentity{
			Type: to.Ptr(armloadtesting.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armloadtesting.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Properties: &armloadtesting.LoadTestProperties{
			Description: to.Ptr("This is new load test resource"),
			Encryption: &armloadtesting.EncryptionProperties{
				Identity: &armloadtesting.EncryptionPropertiesIdentity{
					Type:       to.Ptr(armloadtesting.TypeUserAssigned),
					ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1"),
				},
				KeyURL: to.Ptr("https://dummy.vault.azure.net/keys/dummykey1"),
			},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoadTestResource = armloadtesting.LoadTestResource{
	// 	Name: to.Ptr("myLoadTest"),
	// 	Type: to.Ptr("Microsoft.LoadTestService/loadTests"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.LoadTestService/loadTests/myLoadTest"),
	// 	SystemData: &armloadtesting.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("userId1001"),
	// 		CreatedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("userId1001"),
	// 		LastModifiedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"Team": to.Ptr("Dev Exp"),
	// 	},
	// 	Identity: &armloadtesting.ManagedServiceIdentity{
	// 		Type: to.Ptr(armloadtesting.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("12345678-1234-1234-1234-123456789012"),
	// 		TenantID: to.Ptr("12345678-1234-1234-4321-123456789012"),
	// 		UserAssignedIdentities: map[string]*armloadtesting.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armloadtesting.UserAssignedIdentity{
	// 				ClientID: to.Ptr("12345678-4321-1234-1234-123456789012"),
	// 				PrincipalID: to.Ptr("12345678-1234-4321-1234-123456789012"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armloadtesting.LoadTestProperties{
	// 		Description: to.Ptr("This is new load test resource"),
	// 		DataPlaneURI: to.Ptr("https://myLoadTest.00000000-0000-0000-0000-000000000000.cnt-dp.domain.com"),
	// 		Encryption: &armloadtesting.EncryptionProperties{
	// 			Identity: &armloadtesting.EncryptionPropertiesIdentity{
	// 				Type: to.Ptr(armloadtesting.TypeUserAssigned),
	// 				ResourceID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1"),
	// 			},
	// 			KeyURL: to.Ptr("https://dummy.vault.azure.net/keys/dummykey1"),
	// 		},
	// 		ProvisioningState: to.Ptr(armloadtesting.ResourceStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_Update.json
func ExampleLoadTestsClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLoadTestsClient().BeginUpdate(ctx, "dummyrg", "myLoadTest", armloadtesting.LoadTestResourcePatchRequestBody{
		Identity: &armloadtesting.ManagedServiceIdentity{
			Type: to.Ptr(armloadtesting.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armloadtesting.UserAssignedIdentity{
				"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Properties: &armloadtesting.LoadTestResourcePatchRequestBodyProperties{
			Description: to.Ptr("This is new load test resource"),
			Encryption: &armloadtesting.EncryptionProperties{
				Identity: &armloadtesting.EncryptionPropertiesIdentity{
					Type: to.Ptr(armloadtesting.TypeSystemAssigned),
				},
				KeyURL: to.Ptr("https://dummy.vault.azure.net/keys/dummykey1"),
			},
		},
		Tags: map[string]*string{
			"Division": to.Ptr("LT"),
			"Team":     to.Ptr("Dev Exp"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.LoadTestResource = armloadtesting.LoadTestResource{
	// 	Name: to.Ptr("myLoadTest"),
	// 	Type: to.Ptr("Microsoft.LoadTestService/loadTests"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.LoadTestService/loadTests/myLoadTest"),
	// 	SystemData: &armloadtesting.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		CreatedBy: to.Ptr("userId1001"),
	// 		CreatedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-09-28T12:32:33.000Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("userId1001"),
	// 		LastModifiedByType: to.Ptr(armloadtesting.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westus"),
	// 	Tags: map[string]*string{
	// 		"Division": to.Ptr("LT"),
	// 		"Team": to.Ptr("Dev Exp"),
	// 	},
	// 	Identity: &armloadtesting.ManagedServiceIdentity{
	// 		Type: to.Ptr(armloadtesting.ManagedServiceIdentityTypeSystemAssignedUserAssigned),
	// 		PrincipalID: to.Ptr("12345678-1234-1234-1234-123456789012"),
	// 		TenantID: to.Ptr("12345678-1234-1234-4321-123456789012"),
	// 		UserAssignedIdentities: map[string]*armloadtesting.UserAssignedIdentity{
	// 			"/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/dummyrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armloadtesting.UserAssignedIdentity{
	// 				ClientID: to.Ptr("12345678-4321-1234-1234-123456789012"),
	// 				PrincipalID: to.Ptr("12345678-1234-4321-1234-123456789012"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armloadtesting.LoadTestProperties{
	// 		Description: to.Ptr("This is new load test resource"),
	// 		DataPlaneURI: to.Ptr("https://myLoadTest.00000000-0000-0000-0000-000000000000.cnt-dp.domain.com"),
	// 		Encryption: &armloadtesting.EncryptionProperties{
	// 			Identity: &armloadtesting.EncryptionPropertiesIdentity{
	// 				Type: to.Ptr(armloadtesting.TypeSystemAssigned),
	// 			},
	// 			KeyURL: to.Ptr("https://dummy.vault.azure.net/keys/dummykey1"),
	// 		},
	// 		ProvisioningState: to.Ptr(armloadtesting.ResourceStateSucceeded),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_Delete.json
func ExampleLoadTestsClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewLoadTestsClient().BeginDelete(ctx, "dummyrg", "myLoadTest", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/loadtestservice/resource-manager/Microsoft.LoadTestService/stable/2022-12-01/examples/LoadTests_ListOutboundNetworkDependenciesEndpoints.json
func ExampleLoadTestsClient_NewListOutboundNetworkDependenciesEndpointsPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armloadtesting.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewLoadTestsClient().NewListOutboundNetworkDependenciesEndpointsPager("default-azureloadtest-japaneast", "sampleloadtest", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OutboundEnvironmentEndpointCollection = armloadtesting.OutboundEnvironmentEndpointCollection{
		// 	Value: []*armloadtesting.OutboundEnvironmentEndpoint{
		// 		{
		// 			Category: to.Ptr("Azure Batch"),
		// 			Endpoints: []*armloadtesting.EndpointDependency{
		// 				{
		// 					Description: to.Ptr("Applicable to job manager tasks, tasks that use job scoped authentication, or any task that makes calls to Batch."),
		// 					DomainName: to.Ptr("sampleacct.japaneast.batch.azure.com"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					Description: to.Ptr("Applicable to all Azure Batch pools."),
		// 					DomainName: to.Ptr("japaneast.service.batch.azure.com"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure Storage"),
		// 			Endpoints: []*armloadtesting.EndpointDependency{
		// 				{
		// 					Description: to.Ptr("AutoStorage endpoint for this Batch account. Applicable to all Azure Batch pools under this account."),
		// 					DomainName: to.Ptr("autostorageaccountname.blob.core.windows.net"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					Description: to.Ptr("Applicable to all Azure Batch pools."),
		// 					DomainName: to.Ptr("*.blob.core.windows.net"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					Description: to.Ptr("Applicable to all Azure Batch pools."),
		// 					DomainName: to.Ptr("*.table.core.windows.net"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 				},
		// 				{
		// 					Description: to.Ptr("Applicable to all Azure Batch pools."),
		// 					DomainName: to.Ptr("*.queue.core.windows.net"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Microsoft Package Repository"),
		// 			Endpoints: []*armloadtesting.EndpointDependency{
		// 				{
		// 					Description: to.Ptr("Only applicable to pools containing a Mount Configuration. Learn about Mount Configurations in Batch at https://docs.microsoft.com/azure/batch/virtual-file-mount."),
		// 					DomainName: to.Ptr("packages.microsoft.com"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 		},
		// 		{
		// 			Category: to.Ptr("Azure Key Vault"),
		// 			Endpoints: []*armloadtesting.EndpointDependency{
		// 				{
		// 					Description: to.Ptr("Only applicable to pools containing a Disk Encryption Configuration and whose VM size does not support encryption at host. Learn more about disk encryption in Azure Batch at https://docs.microsoft.com/azure/batch/disk-encryption. Learn more about encryption at host and supported VM sizes at https://docs.microsoft.com/azure/virtual-machines/disks-enable-host-based-encryption-portal."),
		// 					DomainName: to.Ptr("*.vault.azure.net"),
		// 					EndpointDetails: []*armloadtesting.EndpointDetail{
		// 						{
		// 							Port: to.Ptr[int32](443),
		// 					}},
		// 			}},
		// 	}},
		// }
	}
}
