//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/eventgrid/armeventgrid/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// PartnerTopicEventSubscriptionsServer is a fake server for instances of the armeventgrid.PartnerTopicEventSubscriptionsClient type.
type PartnerTopicEventSubscriptionsServer struct {
	// BeginCreateOrUpdate is the fake for method PartnerTopicEventSubscriptionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, eventSubscriptionInfo armeventgrid.EventSubscription, options *armeventgrid.PartnerTopicEventSubscriptionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method PartnerTopicEventSubscriptionsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, options *armeventgrid.PartnerTopicEventSubscriptionsClientBeginDeleteOptions) (resp azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method PartnerTopicEventSubscriptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, options *armeventgrid.PartnerTopicEventSubscriptionsClientGetOptions) (resp azfake.Responder[armeventgrid.PartnerTopicEventSubscriptionsClientGetResponse], errResp azfake.ErrorResponder)

	// GetDeliveryAttributes is the fake for method PartnerTopicEventSubscriptionsClient.GetDeliveryAttributes
	// HTTP status codes to indicate success: http.StatusOK
	GetDeliveryAttributes func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, options *armeventgrid.PartnerTopicEventSubscriptionsClientGetDeliveryAttributesOptions) (resp azfake.Responder[armeventgrid.PartnerTopicEventSubscriptionsClientGetDeliveryAttributesResponse], errResp azfake.ErrorResponder)

	// GetFullURL is the fake for method PartnerTopicEventSubscriptionsClient.GetFullURL
	// HTTP status codes to indicate success: http.StatusOK
	GetFullURL func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, options *armeventgrid.PartnerTopicEventSubscriptionsClientGetFullURLOptions) (resp azfake.Responder[armeventgrid.PartnerTopicEventSubscriptionsClientGetFullURLResponse], errResp azfake.ErrorResponder)

	// NewListByPartnerTopicPager is the fake for method PartnerTopicEventSubscriptionsClient.NewListByPartnerTopicPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByPartnerTopicPager func(resourceGroupName string, partnerTopicName string, options *armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicOptions) (resp azfake.PagerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicResponse])

	// BeginUpdate is the fake for method PartnerTopicEventSubscriptionsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusCreated
	BeginUpdate func(ctx context.Context, resourceGroupName string, partnerTopicName string, eventSubscriptionName string, eventSubscriptionUpdateParameters armeventgrid.EventSubscriptionUpdateParameters, options *armeventgrid.PartnerTopicEventSubscriptionsClientBeginUpdateOptions) (resp azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewPartnerTopicEventSubscriptionsServerTransport creates a new instance of PartnerTopicEventSubscriptionsServerTransport with the provided implementation.
// The returned PartnerTopicEventSubscriptionsServerTransport instance is connected to an instance of armeventgrid.PartnerTopicEventSubscriptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewPartnerTopicEventSubscriptionsServerTransport(srv *PartnerTopicEventSubscriptionsServer) *PartnerTopicEventSubscriptionsServerTransport {
	return &PartnerTopicEventSubscriptionsServerTransport{
		srv:                        srv,
		beginCreateOrUpdate:        newTracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientCreateOrUpdateResponse]](),
		beginDelete:                newTracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientDeleteResponse]](),
		newListByPartnerTopicPager: newTracker[azfake.PagerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicResponse]](),
		beginUpdate:                newTracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientUpdateResponse]](),
	}
}

// PartnerTopicEventSubscriptionsServerTransport connects instances of armeventgrid.PartnerTopicEventSubscriptionsClient to instances of PartnerTopicEventSubscriptionsServer.
// Don't use this type directly, use NewPartnerTopicEventSubscriptionsServerTransport instead.
type PartnerTopicEventSubscriptionsServerTransport struct {
	srv                        *PartnerTopicEventSubscriptionsServer
	beginCreateOrUpdate        *tracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientCreateOrUpdateResponse]]
	beginDelete                *tracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientDeleteResponse]]
	newListByPartnerTopicPager *tracker[azfake.PagerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicResponse]]
	beginUpdate                *tracker[azfake.PollerResponder[armeventgrid.PartnerTopicEventSubscriptionsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for PartnerTopicEventSubscriptionsServerTransport.
func (p *PartnerTopicEventSubscriptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "PartnerTopicEventSubscriptionsClient.BeginCreateOrUpdate":
		resp, err = p.dispatchBeginCreateOrUpdate(req)
	case "PartnerTopicEventSubscriptionsClient.BeginDelete":
		resp, err = p.dispatchBeginDelete(req)
	case "PartnerTopicEventSubscriptionsClient.Get":
		resp, err = p.dispatchGet(req)
	case "PartnerTopicEventSubscriptionsClient.GetDeliveryAttributes":
		resp, err = p.dispatchGetDeliveryAttributes(req)
	case "PartnerTopicEventSubscriptionsClient.GetFullURL":
		resp, err = p.dispatchGetFullURL(req)
	case "PartnerTopicEventSubscriptionsClient.NewListByPartnerTopicPager":
		resp, err = p.dispatchNewListByPartnerTopicPager(req)
	case "PartnerTopicEventSubscriptionsClient.BeginUpdate":
		resp, err = p.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := p.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscription](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		p.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		p.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		p.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if p.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := p.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginDelete(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		p.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		p.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		p.beginDelete.remove(req)
	}

	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscription, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchGetDeliveryAttributes(req *http.Request) (*http.Response, error) {
	if p.srv.GetDeliveryAttributes == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetDeliveryAttributes not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getDeliveryAttributes`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetDeliveryAttributes(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeliveryAttributeListResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchGetFullURL(req *http.Request) (*http.Response, error) {
	if p.srv.GetFullURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetFullURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getFullUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
	if err != nil {
		return nil, err
	}
	eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.GetFullURL(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).EventSubscriptionFullURL, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchNewListByPartnerTopicPager(req *http.Request) (*http.Response, error) {
	if p.srv.NewListByPartnerTopicPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByPartnerTopicPager not implemented")}
	}
	newListByPartnerTopicPager := p.newListByPartnerTopicPager.get(req)
	if newListByPartnerTopicPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicOptions
		if filterParam != nil || topParam != nil {
			options = &armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicOptions{
				Filter: filterParam,
				Top:    topParam,
			}
		}
		resp := p.srv.NewListByPartnerTopicPager(resourceGroupNameParam, partnerTopicNameParam, options)
		newListByPartnerTopicPager = &resp
		p.newListByPartnerTopicPager.add(req, newListByPartnerTopicPager)
		server.PagerResponderInjectNextLinks(newListByPartnerTopicPager, req, func(page *armeventgrid.PartnerTopicEventSubscriptionsClientListByPartnerTopicResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByPartnerTopicPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		p.newListByPartnerTopicPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByPartnerTopicPager) {
		p.newListByPartnerTopicPager.remove(req)
	}
	return resp, nil
}

func (p *PartnerTopicEventSubscriptionsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := p.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.EventGrid/partnerTopics/(?P<partnerTopicName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/eventSubscriptions/(?P<eventSubscriptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armeventgrid.EventSubscriptionUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		partnerTopicNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("partnerTopicName")])
		if err != nil {
			return nil, err
		}
		eventSubscriptionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("eventSubscriptionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := p.srv.BeginUpdate(req.Context(), resourceGroupNameParam, partnerTopicNameParam, eventSubscriptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		p.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusCreated}, resp.StatusCode) {
		p.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		p.beginUpdate.remove(req)
	}

	return resp, nil
}
