//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armdatafactory_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/datafactory/armdatafactory/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/69ece3818b8b0929b43a07c3fe25716427734882/specification/datafactory/resource-manager/Microsoft.DataFactory/stable/2018-06-01/examples/Operations_List.json
func ExampleOperationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armdatafactory.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewOperationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.OperationListResponse = armdatafactory.OperationListResponse{
		// 	Value: []*armdatafactory.Operation{
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/providers/Microsoft.Insights/metricDefinitions/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for datafactories"),
		// 				Operation: to.Ptr("Read datafactories metric definitions"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("datafactories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armdatafactory.OperationProperties{
		// 				ServiceSpecification: &armdatafactory.OperationServiceSpecification{
		// 					MetricSpecifications: []*armdatafactory.OperationMetricSpecification{
		// 						{
		// 							Name: to.Ptr("FailedRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armdatafactory.OperationMetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P1D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 							}},
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("pipelineName"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("activityName"),
		// 									DisplayName: to.Ptr("Activity"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("windowEnd"),
		// 									DisplayName: to.Ptr("Window End"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("windowStart"),
		// 									DisplayName: to.Ptr("Window Start"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Failed Runs"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetricsV1"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("SuccessfulRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Availabilities: []*armdatafactory.OperationMetricAvailability{
		// 								{
		// 									BlobDuration: to.Ptr("P1D"),
		// 									TimeGrain: to.Ptr("PT1H"),
		// 							}},
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("pipelineName"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("activityName"),
		// 									DisplayName: to.Ptr("Activity"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("windowEnd"),
		// 									DisplayName: to.Ptr("Window End"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("windowStart"),
		// 									DisplayName: to.Ptr("Window Start"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Successful Runs"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetricsV1"),
		// 							Unit: to.Ptr("Count"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("datafactories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("datafactories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/providers/Microsoft.Insights/logDefinitions/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the available logs for factories"),
		// 				Operation: to.Ptr("Read factories log definitions"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("The log definition of factories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armdatafactory.OperationProperties{
		// 				ServiceSpecification: &armdatafactory.OperationServiceSpecification{
		// 					LogSpecifications: []*armdatafactory.OperationLogSpecification{
		// 						{
		// 							Name: to.Ptr("ActivityRuns"),
		// 							BlobDuration: to.Ptr("PT1H"),
		// 							DisplayName: to.Ptr("Pipeline activity runs log"),
		// 						},
		// 						{
		// 							Name: to.Ptr("PipelineRuns"),
		// 							BlobDuration: to.Ptr("PT1H"),
		// 							DisplayName: to.Ptr("Pipeline runs log"),
		// 						},
		// 						{
		// 							Name: to.Ptr("TriggerRuns"),
		// 							BlobDuration: to.Ptr("PT1H"),
		// 							DisplayName: to.Ptr("Trigger runs log"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/providers/Microsoft.Insights/diagnosticSettings/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Read diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("factories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/providers/Microsoft.Insights/diagnosticSettings/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or updates the diagnostic setting for the resource"),
		// 				Operation: to.Ptr("Write diagnostic setting"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("factories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/providers/Microsoft.Insights/metricDefinitions/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the available metrics for factories"),
		// 				Operation: to.Ptr("Read metric definitions"),
		// 				Provider: to.Ptr("Microsoft.DataFactory"),
		// 				Resource: to.Ptr("factories"),
		// 			},
		// 			Origin: to.Ptr("system"),
		// 			Properties: &armdatafactory.OperationProperties{
		// 				ServiceSpecification: &armdatafactory.OperationServiceSpecification{
		// 					MetricSpecifications: []*armdatafactory.OperationMetricSpecification{
		// 						{
		// 							Name: to.Ptr("PipelineFailedRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Failed pipeline runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("PipelineSucceededRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Succeeded pipeline runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("ActivityFailedRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("ActivityType"),
		// 									DisplayName: to.Ptr("Activity Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("PipelineName"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Activity"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Failed activity runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("ActivitySucceededRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("ActivityType"),
		// 									DisplayName: to.Ptr("Activity Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("PipelineName"),
		// 									DisplayName: to.Ptr("Pipeline"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Activity"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Succeeded activity runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("TriggerFailedRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Trigger"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Failed trigger runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("TriggerSucceededRuns"),
		// 							AggregationType: to.Ptr("Total"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("Name"),
		// 									DisplayName: to.Ptr("Trigger"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("FailureType"),
		// 									DisplayName: to.Ptr("Failure Type"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Succeeded trigger runs metrics"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Count"),
		// 						},
		// 						{
		// 							Name: to.Ptr("IntegrationRuntimeCpuPercentage"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("IntegrationRuntimeName"),
		// 									DisplayName: to.Ptr("Integration Runtime"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("NodeName"),
		// 									DisplayName: to.Ptr("Integration Runtime Node"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Integration runtime CPU utilization"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Percent"),
		// 						},
		// 						{
		// 							Name: to.Ptr("IntegrationRuntimeAvailableMemory"),
		// 							AggregationType: to.Ptr("Average"),
		// 							Dimensions: []*armdatafactory.OperationMetricDimension{
		// 								{
		// 									Name: to.Ptr("IntegrationRuntimeName"),
		// 									DisplayName: to.Ptr("Integration Runtime"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 								},
		// 								{
		// 									Name: to.Ptr("NodeName"),
		// 									DisplayName: to.Ptr("Integration Runtime Node"),
		// 									ToBeExportedForShoebox: to.Ptr(true),
		// 							}},
		// 							DisplayName: to.Ptr("Integration runtime available memory"),
		// 							EnableRegionalMdmAccount: to.Ptr("false"),
		// 							SourceMdmAccount: to.Ptr("MicrosoftDataFactoryProdShoebox"),
		// 							SourceMdmNamespace: to.Ptr("ADFMetrics"),
		// 							Unit: to.Ptr("Bytes"),
		// 					}},
		// 				},
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/register/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Registers the subscription for the Data Factory Resource Provider."),
		// 				Operation: to.Ptr("Register Data Factory Resource Provider"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory Resource Provider"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/unregister/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Unregisters the subscription for the Data Factory Resource Provider."),
		// 				Operation: to.Ptr("Unregister Data Factory Resource Provider"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory Resource Provider"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the Data Factory."),
		// 				Operation: to.Ptr("Read Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates the Data Factory."),
		// 				Operation: to.Ptr("Create or Update Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes the Data Factory."),
		// 				Operation: to.Ptr("Delete Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/linkedServices/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Linked Service."),
		// 				Operation: to.Ptr("Read Linked Service"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/linkedServices/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Linked Service."),
		// 				Operation: to.Ptr("Delete Linked Service"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/linkedServices/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Linked Service."),
		// 				Operation: to.Ptr("Create or Update Linked Service"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Pipeline."),
		// 				Operation: to.Ptr("Read Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Pipeline."),
		// 				Operation: to.Ptr("Delete Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/pause/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Pauses any Pipeline."),
		// 				Operation: to.Ptr("Pause Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/resume/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Resumes any Pipeline."),
		// 				Operation: to.Ptr("Resume Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/update/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Updates any Pipeline."),
		// 				Operation: to.Ptr("Update Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Pipeline."),
		// 				Operation: to.Ptr("Create or Update Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Dataset."),
		// 				Operation: to.Ptr("Read Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Dataset."),
		// 				Operation: to.Ptr("Delete Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Dataset."),
		// 				Operation: to.Ptr("Create or Update Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/tables/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Dataset."),
		// 				Operation: to.Ptr("Read Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/tables/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Dataset."),
		// 				Operation: to.Ptr("Delete Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/tables/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Dataset."),
		// 				Operation: to.Ptr("Create or Update Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/slices/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the Data Slices in the given period."),
		// 				Operation: to.Ptr("Read Data Slices"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Slice"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/slices/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Update the Status of the Data Slice."),
		// 				Operation: to.Ptr("Update Data Slice Status"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Slice"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/sliceruns/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the Data Slice Run for the given dataset with the given start time."),
		// 				Operation: to.Ptr("Read Data Slice Run"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Slice"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/runs/loginfo/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads a SAS URI to a blob container containing the logs."),
		// 				Operation: to.Ptr("Read Run Log Info"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Run Log"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/activitywindows/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Activity Windows in the Data Factory with specified parameters."),
		// 				Operation: to.Ptr("Read Activity Windows in any Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Activity Windows"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/activitywindows/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Activity Windows for the Pipeline with specified parameters."),
		// 				Operation: to.Ptr("Read Activity Windows for any Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Activity Windows"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datapipelines/activities/activitywindows/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Activity Windows for the Pipeline Activity with specified parameters."),
		// 				Operation: to.Ptr("Read Activity Windows for any Pipeline Activity"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Activity Windows"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/datasets/activitywindows/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Activity Windows for the Dataset with specified parameters."),
		// 				Operation: to.Ptr("Read Activity Windows for any Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Activity Windows"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Gateway."),
		// 				Operation: to.Ptr("Read Gateway"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Gateway."),
		// 				Operation: to.Ptr("Create or Update Gateway"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Gateway."),
		// 				Operation: to.Ptr("Delete Gateway"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/connectioninfo/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the Connection Info for any Gateway."),
		// 				Operation: to.Ptr("Read Gateway Connection Info"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/listauthkeys/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Lists the Authentication Keys for any Gateway."),
		// 				Operation: to.Ptr("List Gateway Authentication Keys"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/datafactories/gateways/regenerateauthkey/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Regenerates the Authentication Keys for any Gateway."),
		// 				Operation: to.Ptr("Regenerate Gateway Authentication Keys"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Gateway"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Data Factory."),
		// 				Operation: to.Ptr("Read Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Create or Update Data Factory"),
		// 				Operation: to.Ptr("Create or Update any Data Factory."),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes Data Factory."),
		// 				Operation: to.Ptr("Delete Data Factory"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/linkedServices/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Linked Service."),
		// 				Operation: to.Ptr("Read Linked Service"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/linkedServices/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes Linked Service."),
		// 				Operation: to.Ptr("Delete Linked Service"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/linkedServices/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Create or Update Linked Service"),
		// 				Operation: to.Ptr("Create or Update any Linked Service."),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Linked Service"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelines/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Pipeline."),
		// 				Operation: to.Ptr("Read Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelines/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes Pipeline."),
		// 				Operation: to.Ptr("Delete Pipeline"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelines/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Create or Update Pipeline"),
		// 				Operation: to.Ptr("Create or Update any Pipeline."),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelines/createrun/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates a run for the Pipeline."),
		// 				Operation: to.Ptr("Create Pipeline Run"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Pipeline"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/cancelpipelinerun/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Cancels the pipeline run specified by the run ID."),
		// 				Operation: to.Ptr("Cancel any Pipeline Run"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelineruns/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the Pipeline Runs."),
		// 				Operation: to.Ptr("Read Pipeline Runs"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/pipelineruns/activityruns/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the activity runs for the specified pipeline run ID."),
		// 				Operation: to.Ptr("Read Activity Runs"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/datasets/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Dataset."),
		// 				Operation: to.Ptr("Read Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/datasets/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Dataset."),
		// 				Operation: to.Ptr("Delete Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/datasets/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Dataset."),
		// 				Operation: to.Ptr("Create or Update Dataset"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Dataset"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Integration Runtime."),
		// 				Operation: to.Ptr("Read Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Integration Runtime."),
		// 				Operation: to.Ptr("Create or Update Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Integration Runtime."),
		// 				Operation: to.Ptr("Delete Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/start/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Starts any Integration Runtime."),
		// 				Operation: to.Ptr("Start Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/stop/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Stops any Integration Runtime."),
		// 				Operation: to.Ptr("Stop Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/getconnectioninfo/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Integration Runtime Connection Info."),
		// 				Operation: to.Ptr("Read Integration Runtime Connection Info"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/getstatus/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads Integration Runtime Status."),
		// 				Operation: to.Ptr("Read Integration Runtime Status"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/listauthkeys/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Lists the Authentication Keys for any Integration Runtime."),
		// 				Operation: to.Ptr("List Integration Runtime Authentication Keys"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/monitoringdata/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Gets the Monitoring Data for any Integration Runtime."),
		// 				Operation: to.Ptr("Get Integration Runtime Monitoring Data"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/nodes/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes the Node for the specified Integration Runtime."),
		// 				Operation: to.Ptr("Delete Integration Runtime Node"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/nodes/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Updates a self-hosted Integration Runtime Node."),
		// 				Operation: to.Ptr("Update Integration Runtime Node"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/nodes/ipAddress/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Returns the IP Address for the specified node of the Integration Runtime."),
		// 				Operation: to.Ptr("Read Integration Runtime Node IP Address"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/synccredentials/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Syncs the Credentials for the specified Integration Runtime."),
		// 				Operation: to.Ptr("Sync Credentials for Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/upgrade/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Upgrades the specified Integration Runtime."),
		// 				Operation: to.Ptr("Upgrade Integration Runtime"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/integrationruntimes/regenerateauthkey/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Regenerates the Authentication Keys for the specified Integration Runtime."),
		// 				Operation: to.Ptr("Regenerate Integration Runtime Authentication Keys"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Integration Runtime"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads any Trigger."),
		// 				Operation: to.Ptr("Read Trigger"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Trigger"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/write"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Creates or Updates any Trigger."),
		// 				Operation: to.Ptr("Create or Update Trigger"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Trigger"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/delete"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Deletes any Trigger."),
		// 				Operation: to.Ptr("Delete Trigger"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Trigger"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/start/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Starts any Trigger."),
		// 				Operation: to.Ptr("Start Trigger"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Trigger"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/stop/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Stops any Trigger."),
		// 				Operation: to.Ptr("Stop Trigger"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Trigger"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/factories/triggers/triggerruns/read"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Reads the Trigger Runs."),
		// 				Operation: to.Ptr("Read Trigger Runs"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("Microsoft.DataFactory/locations/configureFactoryRepo/action"),
		// 			Display: &armdatafactory.OperationDisplay{
		// 				Description: to.Ptr("Configures the repository for the factory."),
		// 				Operation: to.Ptr("Configure Factory Repository"),
		// 				Provider: to.Ptr("Microsoft Data Factory"),
		// 				Resource: to.Ptr("Data Factory"),
		// 			},
		// 	}},
		// }
	}
}
