/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix pam30{

    9, 1,

	{ { (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.3400, 0.283, 1.754, 0.1938, -0.3, 0.436164, 0.161818, 0.161818 },
	{ 7, 2, (double)INT2_MAX, 0.305, 0.15, 0.87, 0.35, -3, 0.479087, 1.014010, 1.162730 },
	{ 6, 2, (double)INT2_MAX, 0.287, 0.11, 0.68, 0.42, -4, 0.499980, 1.688060, 1.951430 },
	{ 5, 2, (double)INT2_MAX, 0.264, 0.079, 0.45, 0.59, -7, 0.533009, 3.377010, 3.871950 },
	{ 10, 1, (double)INT2_MAX, 0.309, 0.15, 0.88, 0.35, -3, 0.474741, 1.372050, 1.788770 },
	{ 9, 1, (double)INT2_MAX, 0.294, 0.11, 0.61, 0.48, -6, 0.492716, 2.463920, 3.186150 },
	{ 8, 1, (double)INT2_MAX, 0.270, 0.072, 0.40, 0.68, -10, 0.521286, 5.368130, 6.763480 } },

	{
		 /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    6, -7, -4, -3, -6, -4, -2, -2, -7, -5, -6, -7, -5,
            -8, -2,  0, -1,-13, -8, -2, -3, -6, -3, -1,-17, -17,
    /*R*/   -7,  8, -6,-10, -8, -2, -9, -9, -2, -5, -8,  0, -4,
            -9, -4, -3, -6, -2,-10, -8, -7, -7, -4, -1,-17, -17,
    /*N*/   -4, -6,  8,  2,-11, -3, -2, -3,  0, -5, -7, -1, -9,
            -9, -6,  0, -2, -8, -4, -8,  6, -6, -3, -1,-17, -17,
    /*D*/   -3,-10,  2,  8,-14, -2,  2, -3, -4, -7,-12, -4,-11,
           -15, -8, -4, -5,-15,-11, -8,  6,-10,  1, -1,-17, -17,
    /*C*/   -6, -8,-11,-14, 10,-14,-14, -9, -7, -6,-15,-14,-13,
           -13, -8, -3, -8,-15, -4, -6,-12, -9,-14, -1,-17, -17,
    /*Q*/   -4, -2, -3, -2,-14,  8,  1, -7,  1, -8, -5, -3, -4,
           -13, -3, -5, -5,-13,-12, -7, -3, -5,  6, -1,-17, -17,
    /*E*/   -2, -9, -2,  2,-14,  1,  8, -4, -5, -5, -9, -4, -7,
           -14, -5, -4, -6,-17, -8, -6,  1, -7,  6, -1,-17, -17,
    /*G*/   -2, -9, -3, -3, -9, -7, -4,  6, -9,-11,-10, -7, -8,
            -9, -6, -2, -6,-15,-14, -5, -3,-10, -5, -1,-17, -17,
    /*H*/   -7, -2,  0, -4, -7,  1, -5, -9,  9, -9, -6, -6,-10,
            -6, -4, -6, -7, -7, -3, -6, -1, -7, -1, -1,-17, -17,
    /*I*/   -5, -5, -5, -7, -6, -8, -5,-11, -9,  8, -1, -6, -1,
            -2, -8, -7, -2,-14, -6,  2, -6,  5, -6, -1,-17, -17,
    /*L*/   -6, -8, -7,-12,-15, -5, -9,-10, -6, -1,  7, -8,  1,
            -3, -7, -8, -7, -6, -7, -2, -9,  6, -7, -1,-17, -17,
    /*K*/   -7,  0, -1, -4,-14, -3, -4, -7, -6, -6, -8,  7, -2,
           -14, -6, -4, -3,-12, -9, -9, -2, -7, -4, -1,-17, -17,
    /*M*/   -5, -4, -9,-11,-13, -4, -7, -8,-10, -1,  1, -2, 11,
            -4, -8, -5, -4,-13,-11, -1,-10,  0, -5, -1,-17, -17,
    /*F*/   -8, -9, -9,-15,-13,-13,-14, -9, -6, -2, -3,-14, -4,
             9,-10, -6, -9, -4,  2, -8,-10, -2,-13, -1,-17, -17,
    /*P*/   -2, -4, -6, -8, -8, -3, -5, -6, -4, -8, -7, -6, -8,
           -10,  8, -2, -4,-14,-13, -6, -7, -7, -4, -1,-17, -17,
    /*S*/    0, -3,  0, -4, -3, -5, -4, -2, -6, -7, -8, -4, -5,
            -6, -2,  6,  0, -5, -7, -6, -1, -8, -5, -1,-17, -17,
    /*T*/   -1, -6, -2, -5, -8, -5, -6, -6, -7, -2, -7, -3, -4,
            -9, -4,  0,  7,-13, -6, -3, -3, -5, -6, -1,-17, -17,
    /*W*/  -13, -2, -8,-15,-15,-13,-17,-15, -7,-14, -6,-12,-13,
            -4,-14, -5,-13, 13, -5,-15,-10, -7,-14, -1,-17, -17,
    /*Y*/   -8,-10, -4,-11, -4,-12, -8,-14, -3, -6, -7, -9,-11,
             2,-13, -7, -6, -5, 10, -7, -6, -7, -9, -1,-17, -17,
    /*V*/   -2, -8, -8, -8, -6, -7, -6, -5, -6,  2, -2, -9, -1,
            -8, -6, -6, -3,-15, -7,  7, -8,  0, -6, -1,-17, -17,
    /*B*/   -3, -7,  6,  6,-12, -3,  1, -3, -1, -6, -9, -2,-10,
           -10, -7, -1, -3,-10, -6, -8,  6, -8,  0, -1,-17, -17,
    /*J*/   -6, -7, -6,-10, -9, -5, -7,-10, -7,  5,  6, -7,  0,
            -2, -7, -8, -5, -7, -7,  0, -8,  6, -6, -1,-17, -17,
    /*Z*/   -3, -4, -3,  1,-14,  6,  6, -5, -1, -6, -7, -4, -5,
           -13, -4, -5, -6,-14, -9, -6,  0, -6,  6, -1,-17, -17,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,-17, -17,
    /***/  -17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,
           -17,-17,-17,-17,-17,-17,-17,-17,-17,-17,-17,  1, -17,
			-17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17,
			-17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17, -17 },

{ {5.9127839295455724e-02, 3.2440614389978224e-04, 1.0035946285397422e-03,
   1.2937791530855702e-03, 3.1489290812535621e-04, 7.8441998276182750e-04,
   1.9549522618591804e-03, 4.4450248999927649e-03, 2.4408739253648561e-04,
   6.3834521530456922e-04, 8.5734186469652062e-04, 6.6918201622206063e-04,
   2.4336822178217660e-04, 1.9674172887918488e-04, 2.6202120968515422e-03,
   5.3063352404797842e-03, 4.2185799566371992e-03, 8.9313082115936708e-06,
   1.8225253115472477e-04, 2.6924708725231086e-03},
  {3.2440614389978224e-04, 3.1662308120430839e-02, 2.3762837035855522e-04,
   5.6563724512424312e-05, 9.3129983865266353e-05, 9.1528180957759745e-04,
   8.6839478291009283e-05, 1.4407449709189928e-04, 8.0713273132343639e-04,
   2.3918939892306258e-04, 1.8565923197220291e-04, 3.6581384858227193e-03,
   1.4663859770241663e-04, 6.8103183598496806e-05, 5.5932452083258294e-04,
   1.0092107276753980e-03, 2.5480695878483489e-04, 2.2193510725567831e-04,
   3.6904551277914591e-05, 1.9661468480294445e-04},
  {1.0035946285397422e-03, 2.3762837035855522e-04, 2.3942402666531522e-02,
   3.3284186062777833e-03, 3.2538350231327974e-05, 4.6226978079510854e-04,
   9.2846484862398504e-04, 1.2584257731785510e-03, 1.5206567357122051e-03,
   2.6711601073772237e-04, 3.0916547891024103e-04, 2.2688803763503840e-03,
   2.7842591589795833e-05, 8.1379367658642105e-05, 2.9181042514696590e-04,
   2.7347990528488269e-03, 1.2577236167229159e-03, 2.6993374401853017e-05,
   2.6944461441064744e-04, 1.8273086910009501e-04},
  {1.2937791530855702e-03, 5.6563724512424312e-05, 3.3284186062777833e-03,
   3.1273803507946972e-02, 1.2103234943893133e-05, 7.6617484041782485e-04,
   5.4382363415210683e-03, 1.3553903446762449e-03, 4.2748415829840124e-04,
   1.3808202761146380e-04, 5.5405232219940619e-05, 8.2915092340941237e-04,
   1.5837617592492976e-05, 1.2183210262808245e-05, 1.6175221090296296e-04,
   9.3274720682462713e-04, 5.4799551604074552e-04, 2.6698310744553494e-06,
   2.7630471952142814e-05, 1.9652464806266956e-04},
  {3.1489290812535621e-04, 9.3129983865266353e-05, 3.2538350231327974e-05,
   1.2103234943893133e-05, 3.0911985925451389e-02, 1.0422909419121936e-05,
   1.3045150483146400e-05, 1.2331325932473484e-04, 8.7403624792468633e-05,
   1.4700821602711548e-04, 1.7204998362221924e-05, 2.0967486284459295e-05,
   4.6716406093025683e-06, 1.5450615839479970e-05, 1.0731935426699396e-04,
   8.8294519055560439e-04, 1.3276608390145865e-04, 1.6423510327768317e-06,
   2.5794057350472414e-04, 2.8675549934525132e-04},
  {7.8441998276182750e-04, 9.1528180957759745e-04, 4.6226978079510854e-04,
   7.6617484041782485e-04, 1.0422909419121936e-05, 2.6544636091699370e-02,
   2.8557369473315988e-03, 3.2014451569115343e-04, 1.7486269599932410e-03,
   9.9252658549817602e-05, 6.0406050527793496e-04, 1.1831024043470412e-03,
   1.5335846864532110e-04, 1.7100059826303178e-05, 7.2911060660364247e-04,
   4.4648205428150529e-04, 3.3667241069963721e-04, 4.8464660724673283e-06,
   1.9368757924195069e-05, 2.5436874878957899e-04},
  {1.9549522618591804e-03, 8.6839478291009283e-05, 9.2846484862398504e-04,
   5.4382363415210683e-03, 1.3045150483146400e-05, 2.8557369473315988e-03,
   3.3517661571345295e-02, 1.0164440084156755e-03, 3.0223151556800276e-04,
   2.7356364677374762e-04, 1.8090379077740425e-04, 9.0138008178105558e-04,
   6.7559973423236150e-05, 1.5496057150416647e-05, 3.8539043828203593e-04,
   7.7702860107301409e-04, 3.7793602875380548e-04, 1.6817714350602577e-06,
   8.3785905046764608e-05, 3.5213850363434608e-04},
  {4.4450248999927649e-03, 1.4407449709189928e-04, 1.2584257731785510e-03,
   1.3553903446762449e-03, 1.2331325932473484e-04, 3.2014451569115343e-04,
   1.0164440084156755e-03, 7.3132026674414694e-02, 1.4265572852210342e-04,
   7.8900361203388875e-05, 2.1034403031175677e-04, 6.1289535748612200e-04,
   7.4245325157996467e-05, 1.5674229370359372e-04, 5.4766647831609131e-04,
   3.4088067901566015e-03, 7.0070498686195871e-04, 5.2853781924046885e-06,
   2.4544028062357452e-05, 8.5444888317695144e-04},
  {2.4408739253648561e-04, 8.0713273132343639e-04, 1.5206567357122051e-03,
   4.2748415829840124e-04, 8.7403624792468633e-05, 1.7486269599932410e-03,
   3.0223151556800276e-04, 1.4265572852210342e-04, 2.5912762590464825e-02,
   5.4172593088878169e-05, 3.5367937307928028e-04, 3.2368239575447064e-04,
   1.3814951744043517e-05, 1.7593656715401314e-04, 4.2250645207888871e-04,
   3.0759142376355817e-04, 1.6958020182452686e-04, 2.8647046074837808e-05,
   3.2560382462402542e-04, 2.5015804822114957e-04},
  {6.3834521530456922e-04, 2.3918939892306258e-04, 2.6711601073772237e-04,
   1.3808202761146380e-04, 1.4700821602711548e-04, 9.9252658549817602e-05,
   2.7356364677374762e-04, 7.8900361203388875e-05, 5.4172593088878169e-05,
   2.5353285377410485e-02, 2.0257509751816058e-03, 3.7763773851518320e-04,
   4.3126365297883206e-04, 6.9390890433520820e-04, 9.9551479665834663e-05,
   2.4863350821043576e-04, 9.5951641417652196e-04, 3.5757593419236457e-06,
   1.3084289995157492e-04, 4.6260165509845463e-03},
  {8.5734186469652062e-04, 1.8565923197220291e-04, 3.0916547891024103e-04,
   5.5405232219940619e-05, 1.7204998362221924e-05, 6.0406050527793496e-04,
   1.8090379077740425e-04, 2.1034403031175677e-04, 3.5367937307928028e-04,
   2.0257509751816058e-03, 7.3000355069562095e-02, 4.1727413572248076e-04,
   1.5642375920382058e-03, 1.4111427667651418e-03, 3.9148184818805121e-04,
   3.4625426602777944e-04, 5.1411236346458541e-04, 1.1411927900827321e-04,
   2.4268846460818286e-04, 2.5562624925597006e-03},
  {6.6918201622206063e-04, 3.6581384858227193e-03, 2.2688803763503840e-03,
   8.2915092340941237e-04, 2.0967486284459295e-05, 1.1831024043470412e-03,
   9.0138008178105558e-04, 6.1289535748612200e-04, 3.2368239575447064e-04,
   3.7763773851518320e-04, 4.1727413572248076e-04, 6.4693883189538823e-02,
   6.6794275671927127e-04, 2.7382721623874425e-05, 4.3433200079450959e-04,
   1.4551172602609017e-03, 1.5845617070211647e-03, 1.4791603367426559e-05,
   1.0031590199504370e-04, 2.4096483294034894e-04},
  {2.4336822178217660e-04, 1.4663859770241663e-04, 2.7842591589795833e-05,
   1.5837617592492976e-05, 4.6716406093025683e-06, 1.5335846864532110e-04,
   6.7559973423236150e-05, 7.4245325157996467e-05, 1.3814951744043517e-05,
   4.3126365297883206e-04, 1.5642375920382058e-03, 6.6794275671927127e-04,
   1.0141188024147338e-02, 1.4660178199119104e-04, 4.8450925637158114e-05,
   1.6515644650970699e-04, 2.2685456319283340e-04, 2.0008298266352844e-06,
   9.3883281308262965e-06, 6.0233931141128079e-04},
  {1.9674172887918488e-04, 6.8103183598496806e-05, 8.1379367658642105e-05,
   1.2183210262808245e-05, 1.5450615839479970e-05, 1.7100059826303178e-05,
   1.5496057150416647e-05, 1.5674229370359372e-04, 1.7593656715401314e-04,
   6.9390890433520820e-04, 1.4111427667651418e-03, 2.7382721623874425e-05,
   1.4660178199119104e-04, 3.3860977281888867e-02, 7.1900609504981099e-05,
   3.1517744951616293e-04, 1.1969179294550922e-04, 8.8987284001973936e-05,
   2.1252281905202656e-03, 1.7152669910871525e-04},
  {2.6202120968515422e-03, 5.5932452083258294e-04, 2.9181042514696590e-04,
   1.6175221090296296e-04, 1.0731935426699396e-04, 7.2911060660364247e-04,
   3.8539043828203593e-04, 5.4766647831609131e-04, 4.2250645207888871e-04,
   9.9551479665834663e-05, 3.9148184818805121e-04, 4.3433200079450959e-04,
   4.8450925637158114e-05, 7.1900609504981099e-05, 4.0604206849577246e-02,
   2.0119339905674016e-03, 7.1262984113373655e-04, 4.7982296290983556e-06,
   1.4865662060036108e-05, 4.6067081670332334e-04},
  {5.3063352404797842e-03, 1.0092107276753980e-03, 2.7347990528488269e-03,
   9.3274720682462713e-04, 8.8294519055560439e-04, 4.4648205428150529e-04,
   7.7702860107301409e-04, 3.4088067901566015e-03, 3.0759142376355817e-04,
   2.4863350821043576e-04, 3.4625426602777944e-04, 1.4551172602609017e-03,
   1.6515644650970699e-04, 3.1517744951616293e-04, 2.0119339905674016e-03,
   4.3704313725631293e-02, 4.6622796190467931e-03, 1.3084508692320411e-04,
   2.0094952100191171e-04, 5.3046884366373238e-04},
  {4.2185799566371992e-03, 2.5480695878483489e-04, 1.2577236167229159e-03,
   5.4799551604074552e-04, 1.3276608390145865e-04, 3.3667241069963721e-04,
   3.7793602875380548e-04, 7.0070498686195871e-04, 1.6958020182452686e-04,
   9.5951641417652196e-04, 5.1411236346458541e-04, 1.5845617070211647e-03,
   2.2685456319283340e-04, 1.1969179294550922e-04, 7.1262984113373655e-04,
   4.6622796190467931e-03, 4.0080501117597984e-02, 7.7221567079978049e-06,
   1.9614260534399206e-04, 1.4808862501356529e-03},
  {8.9313082115936708e-06, 2.2193510725567831e-04, 2.6993374401853017e-05,
   2.6698310744553494e-06, 1.6423510327768317e-06, 4.8464660724673283e-06,
   1.6817714350602577e-06, 5.2853781924046885e-06, 2.8647046074837808e-05,
   3.5757593419236457e-06, 1.1411927900827321e-04, 1.4791603367426559e-05,
   2.0008298266352844e-06, 8.8987284001973936e-05, 4.7982296290983556e-06,
   1.3084508692320411e-04, 7.7221567079978049e-06, 9.7663430469613309e-03,
   5.4428834502404551e-05, 3.4341494426087616e-06},
  {1.8225253115472477e-04, 3.6904551277914591e-05, 2.6944461441064744e-04,
   2.7630471952142814e-05, 2.5794057350472414e-04, 1.9368757924195069e-05,
   8.3785905046764608e-05, 2.4544028062357452e-05, 3.2560382462402542e-04,
   1.3084289995157492e-04, 2.4268846460818286e-04, 1.0031590199504370e-04,
   9.3883281308262965e-06, 2.1252281905202656e-03, 1.4865662060036108e-05,
   2.0094952100191171e-04, 1.9614260534399206e-04, 5.4428834502404551e-05,
   2.5458081876085920e-02, 1.5581070490829142e-04},
  {2.6924708725231086e-03, 1.9661468480294445e-04, 1.8273086910009501e-04,
   1.9652464806266956e-04, 2.8675549934525132e-04, 2.5436874878957899e-04,
   3.5213850363434608e-04, 8.5444888317695144e-04, 2.5015804822114957e-04,
   4.6260165509845463e-03, 2.5562624925597006e-03, 2.4096483294034894e-04,
   6.0233931141128079e-04, 1.7152669910871525e-04, 4.6067081670332334e-04,
   5.3046884366373238e-04, 1.4808862501356529e-03, 3.4341494426087616e-06,
   1.5581070490829142e-04, 4.8623010168479329e-02} },

   { 8.7126757718998679e-02, 4.0903890307999048e-02, 4.0432285538126674e-02,
    4.6871932807633972e-02, 3.3473507356366124e-02, 3.8255436978704142e-02,
    4.9530476921569762e-02, 8.8612083613937145e-02, 3.3618414314618796e-02,
    3.6885613388971901e-02, 8.5357443758733623e-02, 8.0481583375956817e-02,
    1.4752761600830055e-02, 3.9771658566274730e-02, 5.0679914836743105e-02,
    6.9577076005018168e-02, 5.8541664190993777e-02, 1.0493678893463984e-02,
    2.9916218247065893e-02, 6.4717601577993583e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {0.00000000e+00, 7.78912912e+00, 3.02026381e-01, 1.07971742e-01,
    3.16807704e-01, 4.53014491e-01, 5.67768414e-02, 5.75744366e-01,
    8.33329143e-02, 1.98631007e-01, 9.54324770e-02, 1.15281887e-01,
    1.89338526e-01, 2.84890839e-01, 5.93402017e-01, 2.35344432e-01,
    9.10275603e-02, 8.75340369e-01, 8.27084092e-01, 4.77504036e-01,
    9.76867708e-03, 7.50000000e-01, 6.99222384e-02, 3.58158006e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.40431646e-01},
   {0.00000000e+00, 3.02026381e-01, 8.11766307e+00, 1.52757717e-02,
    8.45582330e+00, 1.47233532e+00, 2.69459344e-02, 3.37867839e-01,
    6.63755159e-01, 1.25827363e-01, 4.40914175e-01, 4.89221062e-02,
    3.39137767e-02, 7.72564409e+00, 1.02509984e-01, 3.67813095e-01,
    8.23817770e-02, 6.03773710e-01, 3.53305100e-01, 6.71234492e-02,
    3.23783774e-02, 7.50000000e-01, 1.13742904e-01, 9.91005473e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.21274943e-02},
   {0.00000000e+00, 1.07971742e-01, 1.52757717e-02, 2.75882699e+01,
    7.71413760e-03, 7.86819951e-03, 1.16056875e-02, 4.15734061e-02,
    7.76695875e-02, 1.19064797e-01, 7.78302876e-03, 6.02160155e-03,
    9.46008155e-03, 2.40417467e-02, 6.32617140e-02, 8.13944094e-03,
    6.80179741e-02, 3.79110970e-01, 6.77518036e-02, 1.32369559e-01,
    4.67559620e-03, 7.50000000e-01, 2.57579768e-01, 7.98640138e-03,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 4.01312493e-02},
   {0.00000000e+00, 3.16807704e-01, 8.45582330e+00, 7.71413760e-03,
    1.42349183e+01, 2.34246282e+00, 6.53544516e-03, 3.26331184e-01,
    2.71287596e-01, 7.98669838e-02, 2.19798242e-01, 1.38483017e-02,
    2.29035955e-02, 1.75629226e+00, 6.80928461e-02, 4.27289142e-01,
    2.95026156e-02, 2.86012439e-01, 1.99709663e-01, 6.47860871e-02,
    5.42804139e-03, 7.50000000e-01, 1.97046510e-02, 1.50786644e+00,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 3.37687752e-02},
   {0.00000000e+00, 4.53014491e-01, 1.47233532e+00, 7.86819951e-03,
    2.34246282e+00, 1.36624533e+01, 7.86638136e-03, 2.31589040e-01,
    1.81505594e-01, 1.49736909e-01, 2.26119978e-01, 4.27891596e-02,
    9.24578171e-02, 4.63622671e-01, 1.53529752e-01, 1.50713628e+00,
    4.28627549e-02, 2.25474962e-01, 1.30340902e-01, 1.09854687e-01,
    3.23568839e-03, 7.50000000e-01, 5.65446816e-02, 8.36539662e+00,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50595678e-02},
   {0.00000000e+00, 5.67768414e-02, 2.69459344e-02, 1.16056875e-02,
    6.53544516e-03, 7.86638136e-03, 2.14068164e+01, 4.44753676e-02,
    1.31584637e-01, 4.73011553e-01, 8.55473177e-03, 4.15676862e-01,
    2.49857403e-01, 5.06072009e-02, 3.56716332e-02, 1.12390799e-02,
    4.18628794e-02, 1.13897780e-01, 5.14073961e-02, 6.66400959e-02,
    2.13219283e-01, 7.50000000e-01, 1.78617980e+00, 9.33613946e-03,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 4.32977029e-01},
   {0.00000000e+00, 5.75744366e-01, 3.37867839e-01, 4.15734061e-02,
    3.26331184e-01, 2.31589040e-01, 4.44753676e-02, 9.31368857e+00,
    4.78871557e-02, 2.41395424e-02, 8.59403011e-02, 2.78096704e-02,
    5.67940501e-02, 3.51241937e-01, 1.21951553e-01, 9.44408638e-02,
    3.97493058e-02, 5.52895766e-01, 1.35075690e-01, 1.48994667e-01,
    5.68401675e-03, 7.50000000e-01, 9.25861867e-03, 1.71822465e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 2.67022462e-02},
   {0.00000000e+00, 8.33329143e-02, 6.63755159e-01, 7.76695875e-02,
    2.71287596e-01, 1.81505594e-01, 1.31584637e-01, 4.78871557e-02,
    2.29276353e+01, 4.36863126e-02, 1.19631443e-01, 1.23251186e-01,
    2.78547216e-02, 1.11873100e+00, 2.47982049e-01, 1.35964891e+00,
    5.86952720e-01, 1.31501535e-01, 8.61653901e-02, 1.14978024e-01,
    8.12035191e-02, 7.50000000e-01, 3.23746871e-01, 6.94918113e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.92432853e-02},
   {0.00000000e+00, 1.98631007e-01, 1.25827363e-01, 1.19064797e-01,
    7.98669838e-02, 1.49736909e-01, 4.73011553e-01, 2.41395424e-02,
    4.36863126e-02, 1.86346064e+01, 1.27210180e-01, 6.43409762e-01,
    7.92524183e-01, 1.79107849e-01, 5.32543187e-02, 7.03383168e-02,
    1.58533228e-01, 9.68805230e-02, 4.44355269e-01, 1.93788392e+00,
    9.23811792e-03, 7.50000000e-01, 1.18573178e-01, 1.15136508e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.07207247e+00},
   {0.00000000e+00, 9.54324770e-02, 4.40914175e-01, 7.78302876e-03,
    2.19798242e-01, 2.26119978e-01, 8.55473177e-03, 8.59403011e-02,
    1.19631443e-01, 1.27210180e-01, 9.98780825e+00, 6.07412260e-02,
    5.62560724e-01, 6.97247226e-01, 1.06485246e-01, 3.84266618e-01,
    1.11121735e+00, 2.59857530e-01, 3.36316040e-01, 4.62631009e-02,
    1.75142268e-02, 7.50000000e-01, 4.16645387e-02, 2.95037286e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 8.07975645e-02},
   {0.00000000e+00, 1.15281887e-01, 4.89221062e-02, 6.02160155e-03,
    1.38483017e-02, 4.27891596e-02, 4.15676862e-01, 2.78096704e-02,
    1.23251186e-01, 6.43409762e-01, 6.07412260e-02, 1.00194105e+01,
    1.24218990e+00, 8.95821132e-02, 9.04970355e-02, 1.84988987e-01,
    5.31753716e-02, 5.83025512e-02, 1.02884887e-01, 4.62744892e-01,
    1.27405990e-01, 7.50000000e-01, 9.50388211e-02, 1.04757148e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.19029657e+00},
   {0.00000000e+00, 1.89338526e-01, 3.39137767e-02, 9.46008155e-03,
    2.29035955e-02, 9.24578171e-02, 2.49857403e-01, 5.67940501e-02,
    2.78547216e-02, 7.92524183e-01, 5.62560724e-01, 1.24218990e+00,
    4.65953079e+01, 4.66775487e-02, 6.48026667e-02, 2.71732304e-01,
    2.43002286e-01, 1.60899996e-01, 2.62669188e-01, 6.30878126e-01,
    1.29243603e-02, 7.50000000e-01, 2.12719960e-02, 1.70582240e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.10650779e+00},
   {0.00000000e+00, 2.84890839e-01, 7.72564409e+00, 2.40417467e-02,
    1.75629226e+00, 4.63622671e-01, 5.06072009e-02, 3.51241937e-01,
    1.11873100e+00, 1.79107849e-01, 6.97247226e-01, 8.95821132e-02,
    4.66775487e-02, 1.46457342e+01, 1.42408737e-01, 2.98864303e-01,
    1.43682999e-01, 9.72144796e-01, 5.31363673e-01, 6.98330827e-02,
    6.36210916e-02, 7.50000000e-01, 2.22758622e-01, 3.91824098e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.16595604e-01},
   {0.00000000e+00, 5.93402017e-01, 1.02509984e-01, 6.32617140e-02,
    6.80928461e-02, 1.53529752e-01, 3.56716332e-02, 1.21951553e-01,
    2.47982049e-01, 5.32543187e-02, 1.06485246e-01, 9.04970355e-02,
    6.48026667e-02, 1.42408737e-01, 1.58088136e+01, 3.76066261e-01,
    2.69813309e-01, 5.70573606e-01, 2.40194503e-01, 1.40453450e-01,
    9.02230244e-03, 7.50000000e-01, 9.80486654e-03, 2.50506944e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.92594202e-02},
   {0.00000000e+00, 2.35344432e-01, 3.67813095e-01, 8.13944094e-03,
    4.27289142e-01, 1.50713628e+00, 1.12390799e-02, 9.44408638e-02,
    1.35964891e+00, 7.03383168e-02, 3.84266618e-01, 1.84988987e-01,
    2.71732304e-01, 2.98864303e-01, 3.76066261e-01, 1.81380436e+01,
    5.84920778e-01, 1.67743101e-01, 1.50331260e-01, 1.02742037e-01,
    1.20726953e-02, 7.50000000e-01, 1.69239569e-02, 8.75457039e+00,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.50394300e-01},
   {0.00000000e+00, 9.10275603e-02, 8.23817770e-02, 6.80179741e-02,
    2.95026156e-02, 4.28627549e-02, 4.18628794e-02, 3.97493058e-02,
    5.86952720e-01, 1.58533228e-01, 1.11121735e+00, 5.31753716e-02,
    2.43002286e-01, 1.43682999e-01, 2.69813309e-01, 5.84920778e-01,
    1.89240175e+01, 3.54610075e-01, 1.06409795e-01, 7.42726505e-02,
    5.17051285e-01, 7.50000000e-01, 3.01584225e-02, 2.79081365e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 8.49660454e-02},
   {0.00000000e+00, 8.75340369e-01, 6.03773710e-01, 3.79110970e-01,
    2.86012439e-01, 2.25474962e-01, 1.13897780e-01, 5.52895766e-01,
    1.31501535e-01, 9.68805230e-02, 2.59857530e-01, 5.83025512e-02,
    1.60899996e-01, 9.72144796e-01, 5.70573606e-01, 1.67743101e-01,
    3.54610075e-01, 9.02800848e+00, 1.14463515e+00, 1.17807053e-01,
    1.79210510e-01, 7.50000000e-01, 9.65415148e-02, 2.00316511e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.99430663e-02},
   {0.00000000e+00, 8.27084092e-01, 3.53305100e-01, 6.77518036e-02,
    1.99709663e-01, 1.30340902e-01, 5.14073961e-02, 1.35075690e-01,
    8.61653901e-02, 4.44355269e-01, 3.36316040e-01, 1.02884887e-01,
    2.62669188e-01, 5.31363673e-01, 2.40194503e-01, 1.50331260e-01,
    1.06409795e-01, 1.14463515e+00, 1.16950751e+01, 3.90871695e-01,
    1.25703039e-02, 7.50000000e-01, 1.11995399e-01, 1.39052321e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 2.05920141e-01},
   {0.00000000e+00, 4.77504036e-01, 6.71234492e-02, 1.32369559e-01,
    6.47860871e-02, 1.09854687e-01, 6.66400959e-02, 1.48994667e-01,
    1.14978024e-01, 1.93788392e+00, 4.62631009e-02, 4.62744892e-01,
    6.30878126e-01, 6.98330827e-02, 1.40453450e-01, 1.02742037e-01,
    7.42726505e-02, 1.17807053e-01, 3.90871695e-01, 1.16090589e+01,
    5.05672115e-03, 7.50000000e-01, 8.04763342e-02, 1.06755129e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.07853260e-01},
   {0.00000000e+00, 9.76867708e-03, 3.23783774e-02, 4.67559620e-03,
    5.42804139e-03, 3.23568839e-03, 2.13219283e-01, 5.68401675e-03,
    8.12035191e-02, 9.23811792e-03, 1.75142268e-02, 1.27405990e-01,
    1.29243603e-02, 6.36210916e-02, 9.02230244e-03, 1.20726953e-02,
    5.17051285e-01, 1.79210510e-01, 1.25703039e-02, 5.05672115e-03,
    8.86903633e+01, 7.50000000e-01, 1.73378233e-01, 7.08668846e-03,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 9.17500230e-02},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 6.99222384e-02, 1.13742904e-01, 2.57579768e-01,
    1.97046510e-02, 5.65446816e-02, 1.78617980e+00, 9.25861867e-03,
    3.23746871e-01, 1.18573178e-01, 4.16645387e-02, 9.50388211e-02,
    2.12719960e-02, 2.22758622e-01, 9.80486654e-03, 1.69239569e-02,
    3.01584225e-02, 9.65415148e-02, 1.11995399e-01, 8.04763342e-02,
    1.73378233e-01, 7.50000000e-01, 2.84454162e+01, 3.92787209e-02,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.02140077e-01},
   {0.00000000e+00, 3.58158006e-01, 9.91005473e-01, 7.98640138e-03,
    1.50786644e+00, 8.36539662e+00, 9.33613946e-03, 1.71822465e-01,
    6.94918113e-01, 1.15136508e-01, 2.95037286e-01, 1.04757148e-01,
    1.70582240e-01, 3.91824098e-01, 2.50506944e-01, 8.75457039e+00,
    2.79081365e-01, 2.00316511e-01, 1.39052321e-01, 1.06755129e-01,
    7.08668846e-03, 7.50000000e-01, 3.92787209e-02, 8.53499117e+00,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 1.07889016e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 3.00000000e-03, 3.00000000e-03, 3.00000000e-03,
    3.00000000e-03, 1.33300000e+00, 3.00000000e-03, 3.00000000e-03},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 1.40431646e-01, 7.21274943e-02, 4.01312493e-02,
    3.37687752e-02, 7.50595678e-02, 4.32977029e-01, 2.67022462e-02,
    9.92432853e-02, 6.07207247e+00, 8.07975645e-02, 7.19029657e+00,
    1.10650779e+00, 1.16595604e-01, 7.92594202e-02, 1.50394300e-01,
    8.49660454e-02, 6.99430663e-02, 2.05920141e-01, 9.07853260e-01,
    9.17500230e-02, 7.50000000e-01, 1.02140077e-01, 1.07889016e-01,
    7.50000000e-01, 3.00000000e-03, 7.50000000e-01, 6.85288369e+00} }

};

}