#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Sable
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240408.1

PLAYIT_COMPATIBILITY_LEVEL='2.28'

GAME_ID='sable'
GAME_NAME='Sable'

ARCHIVE_BASE_0_NAME='setup_sable_4.3.4_(64bit)_(60909).exe'
ARCHIVE_BASE_0_MD5='5f11322d659afe9bb2c5434470a05445'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_sable_4.3.4_(64bit)_(60909)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='a1cc6c702d15a0fe99c00b913416f73b'
ARCHIVE_BASE_0_SIZE='2300000'
ARCHIVE_BASE_0_VERSION='4.3.4-gog60909'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/sable'

UNITY3D_NAME='sable'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Shedworks/Sable/SaveData'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
